package com.ejie.ab04b.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.ab04b.parse.MessageParser;
import com.ejie.gat.xml.MessageListType;

/**
 * @author GFI-NORTE
 * 
 */
public final class GatUtils {

	private static final Logger LOGGER = LoggerFactory
			.getLogger(GatUtils.class);

	private static GatUtils instance;

	/**
	 * Constructor privado.
	 */
	private GatUtils() {

	}

	/**
	 * Gets the single instance of GatUtils.
	 * 
	 *  ToolkitParameterUtils
	 *
	 * @return single instance of GatUtils
	 */
	public static GatUtils getInstance() {
		if (GatUtils.instance == null) {
			GatUtils.instance = new GatUtils();
		}
		return GatUtils.instance;
	}

	/**
	 * Devuelve un objeto T65BDocumentIDType a partir de su representación XML
	 * en String.
	 * 
	 *  response
	 *            String
	 *  T65BDocumentIDType
	 *
	 * @param response the response
	 * @return the gat response as task
	 */
	public MessageListType getGatResponseAsTask(String response) {

		GatUtils.LOGGER.info("getGatResponseAsTask", "INIT");

		MessageListType obj = null;
		try {
			obj = (MessageListType) new MessageParser<MessageListType>(
					MessageListType.class.getPackage().getName())
					.parse(response);
		} catch (Exception e) {
			GatUtils.LOGGER
					.error("getGatResponseAsTask - Error en el parseo del objeto response como MessageListType");
		}

		GatUtils.LOGGER.info("getGatResponseAsTask", "END");

		return obj;
	}

}
